<?php

return [
/*
* Provider .
*/
'provider'  => 'apm',

/*
* Package .
*/
'package'   => 'photo_setting',

/*
* Modules .
*/
'modules'   => ['photo_settings'],

'photo_settings' => [
                    'Name'          => 'PhotoSettings',
                    'name'          => 'photo_settings',
                    'table'         => 'photo_settings',
                    'model'         => 'Apm\PhotoSetting\Models\PhotoSettings',
                    'image'         => [
                        'xs'        => ['width' => '60',         'height' => '45'],
                        'sm'        => ['width' => '100',        'height' => '75'],
                        'md'        => ['width' => '460',        'height' => '345'],
                        'lg'        => ['width' => '800',        'height' => '600'],
                        'xl'        => ['width' => '1000',       'height' => '750'],
                        ],

                    'fillable'          => ['user_id', 'name',  'icon',  'crop_size',  'quality',  'price'],
                    'listfields'        => ['id', 'name',  'icon',  'crop_size',  'quality',  'price'],
                    'translatable'      => ['name',  'icon',  'crop_size',  'quality',  'price'],

                    'upload-folder'     => '/uploads/photo_setting/photo_settings',
                    'uploadable'        => [
                                                'single'    => [],
                                                'multiple'  => [],
                                            ],
                ],
];
