<?php

namespace Apm\PhotoSetting\Http\Controllers;

use App\Http\Controllers\AdminController as AdminController;
use Former;
use Apm\PhotoSetting\Http\Requests\PhotoSettingsAdminRequest;
use Apm\PhotoSetting\Interfaces\PhotoSettingsRepositoryInterface;
use Response;

/**
 * Admin controller class.
 */
class PhotoSettingsAdminController extends AdminController
{
    /**
     * Initialize photo_settings controller.
     *
     * @param type PhotoSettingsRepositoryInterface $photo_settings
     *
     * @return type
     */
    public function __construct(PhotoSettingsRepositoryInterface $photo_settings)
    {
        $this->model = $photo_settings;
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(PhotoSettingsAdminRequest $request)
    {
        if ($request->wantsJson()) {
            $array = $this->model->json();
            foreach ($array as $key => $row) {
                $array[$key] = array_only($row, config('photo_setting.photo_settings.listfields'));
            }

            return ['data' => $array];
        }

        $this->theme->prependTitle(trans('photo_setting::photo_settings.names').' :: ');

        return $this->theme->of('photo_setting::admin.photo_settings.index')->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function show(PhotoSettingsAdminRequest $request, $id)
    {
        $photo_settings = $this->model->find($id);

        if (empty($photo_settings)) {
            if ($request->wantsJson()) {
                return [];
            }

            return view('photo_setting::admin.photo_settings.new');
        }

        if ($request->wantsJson()) {
            return $photo_settings;
        }

        Former::populate($photo_settings);

        return view('photo_setting::admin.photo_settings.show', compact('photo_settings'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(PhotoSettingsAdminRequest $request)
    {
        $photo_settings = $this->model->findOrNew(0);
        Former::populate($photo_settings);

        return view('photo_setting::admin.photo_settings.create', compact('photo_settings'));
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(PhotoSettingsAdminRequest $request)
    {
        try {
            $attributes = $request->all();
            $photo_settings = $this->model->create($attributes);

            return $this->success(trans('messages.success.created', ['Module' => trans('photo_setting::photo_settings.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function edit(PhotoSettingsAdminRequest $request, $id)
    {
        $photo_settings = $this->model->find($id);

        Former::populate($photo_settings);

        return view('photo_setting::admin.photo_settings.edit', compact('photo_settings'));
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function update(PhotoSettingsAdminRequest $request, $id)
    {
        try {
            $attributes = $request->all();
            $photo_settings = $this->model->update($attributes, $id);

            return $this->success(trans('messages.success.updated', ['Module' => trans('photo_setting::photo_settings.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(PhotoSettingsAdminRequest $request, $id)
    {
        try {
            $this->model->delete($id);

            return $this->success(trans('message.success.deleted', ['Module' => trans('photo_setting::photo_settings.name')]), 200);
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }
}
