<?php

namespace Apm\PhotoSetting\Http\Controllers;

use App\Http\Controllers\PublicController as CMSPublicController;
use Apm\PhotoSetting\Interfaces\PhotoSettingsRepositoryInterface;

class PhotoSettingsPublicController extends CMSPublicController
{
    /**
     * Constructor.
     *
     * @param type \Apm\PhotoSettings\Interfaces\PhotoSettingsRepositoryInterface $photo_settings
     *
     * @return type
     */
    public function __construct(PhotoSettingsRepositoryInterface $photo_settings)
    {
        $this->model = $photo_settings;
        parent::__construct();
    }

    /**
     * Show photo_settings's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $photo_settings = $this->model->all();

        return $this->theme->of('photo_setting::public.photo_settings.index', compact('photo_settings'))->render();
    }

    /**
     * Show photo_settings.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $photo_settings = $this->model->findBySlug($slug);

        return $this->theme->of('photo_setting::public.photo_settings.show', compact('photo_settings'))->render();
    }
}
