<?php

namespace Apm\PhotoSetting\Http\Controllers;

use App\Http\Controllers\UserController as UserController;
use Former;
use Apm\PhotoSetting\Http\Requests\PhotoSettingsUserRequest;
use Apm\PhotoSetting\Interfaces\PhotoSettingsRepositoryInterface;
use Response;
use User;

class PhotoSettingsUserController extends UserController
{
    /**
     * Initialize photo_settings controller.
     *
     * @param type PhotoSettingsRepositoryInterface $photo_settings
     *
     * @return type
     */
    public function __construct(PhotoSettingsRepositoryInterface $photo_settings)
    {
        $this->model = $photo_settings;
        $this->model->setUserFilter();
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(PhotoSettingsUserRequest $request)
    {
        $photo_settings = $this->model->all();

        $this->theme->prependTitle(trans('photo_setting::photo_settings.names').' :: ');

        return $this->theme->of('photo_setting::user.photo_settings.index', compact('photo_settings'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function show(PhotoSettingsUserRequest $request, $role, $id)
    {
        $photo_settings = $this->model->find($id);

        return $this->theme->of('photo_setting::user.photo_settings.show', compact('photo_settings'))->render();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(PhotoSettingsUserRequest $request)
    {
        $photo_settings = $this->model->findOrNew(0);

        Former::populate($photo_settings);

        return $this->theme->of('photo_setting::user.photo_settings.create', compact('photo_settings'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(PhotoSettingsUserRequest $request)
    {
        try {
            $attributes = $request->all();
            $photo_settings = $this->model->create($attributes);

            return $this->success(trans('messages.success.created', ['Module' => trans('photo_setting::photo_settings.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function edit(PhotoSettingsUserRequest $request, $role, $id)
    {
        $photo_settings = $this->model->find($id);

        Former::populate($photo_settings);

        return $this->theme->of('photo_setting::user.photo_settings.edit', compact('photo_settings'))->render();
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function update(PhotoSettingsUserRequest $request, $role, $id)
    {
        try {
            $attributes = $request->all();
            $photo_settings = $this->model->update($attributes, $id);

            return $this->success(trans('messages.success.updated', ['Module' => trans('photo_setting::photo_settings.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(PhotoSettingsUserRequest $request, $role, $id)
    {
        try {
            $this->model->delete($id);

            return $this->success(trans('message.success.deleted', ['Module' => trans('photo_setting::photo_settings.name')]), 200);
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }
}
