# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/issue/xss/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Issue\\Xss\\": "packages/issue/xss/src",
            "Issue\\Xss\\Seeders\\": "packages/issue/xss/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Issue\Xss\Providers\XssServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Xss'  => Issue\Xss\Facades\Xss::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Issue\\Xss\\Seeders\\XssTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Issue\Xss\Providers\XssServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Issue\Xss\Providers\XssServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Issue\Xss\Providers\XssServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/xss/{modulename}

**User**

    http://path-to-route-folder/user/xss/{modulename}

**Public**

    http://path-to-route-folder/xsses


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/xss/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/xss/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/xss/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/xss/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/xss/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/xss/{modulename}/{slug}
    METHOD: GET