Lavalite package that provides xss management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `issue/xss`.

    "issue/xss": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Issue\Xss\Providers\XssServiceProvider::class,

And also add it to alias

    'Xss'  => Issue\Xss\Facades\Xss::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Issue\\Xss\\Seeders\\XssTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Issue\Xss\Providers\XssServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Issue\Xss\Providers\XssServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Issue\Xss\Providers\XssServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/xss/{modulename}

**User**

    http://path-to-route-folder/user/xss/{modulename}

**Public**

    http://path-to-route-folder/xsses


### API endpoints

**List**

    http://path-to-route-folder/api/user/xss/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/xss/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/xss/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/xss/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/xss/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/xss/{modulename}/{slug}
    METHOD: GET