<?php

return [
/*
* Provider .
*/
'provider'  => 'apm',

/*
* Package .
*/
'package'   => 'order',

/*
* Modules .
*/
'modules'   => ['order', 'order_item'],

'order' => [
                    'Name'          => 'Order',
                    'name'          => 'order',
                    'table'         => 'orders',
                    'model'         => 'Apm\Order\Models\Order',
                    'image'         => [
                        'xs'        => ['width' => '60',         'height' => '45'],
                        'sm'        => ['width' => '100',        'height' => '75'],
                        'md'        => ['width' => '460',        'height' => '345'],
                        'lg'        => ['width' => '800',        'height' => '600'],
                        'xl'        => ['width' => '1000',       'height' => '750'],
                        ],

                    'fillable'          => ['user_id', 'name',  'project_type',  'adjustment',  'address_id',  'total',  'status',  'expire_date'],
                    'listfields'        => ['id', 'name',  'project_type',  'adjustment',  'address_id',  'total',  'status',  'expire_date'],
                    'translatable'      => ['name',  'project_type',  'adjustment',  'address_id',  'total',  'status',  'expire_date'],

                    'upload-folder'     => '/uploads/order/order',
                    'uploadable'        => [
                                                'single'    => [],
                                                'multiple'  => [],
                                            ],
                ],'order_item' => [
                    'Name'          => 'OrderItem',
                    'name'          => 'order_item',
                    'table'         => 'order_items',
                    'model'         => 'Apm\Order\Models\OrderItem',
                    'image'         => [
                        'xs'        => ['width' => '60',         'height' => '45'],
                        'sm'        => ['width' => '100',        'height' => '75'],
                        'md'        => ['width' => '460',        'height' => '345'],
                        'lg'        => ['width' => '800',        'height' => '600'],
                        'xl'        => ['width' => '1000',       'height' => '750'],
                        ],

                    'fillable'          => ['user_id', 'order_id',  'orginal_path',  'cropped_path',  'quantity',  'price',  'crop_size',  'crop_left',  'crop_top',  'img_x',  'img_y',  'img_height',  'img_width',  'rotate',  'zoom'],
                    'listfields'        => ['id', 'order_id',  'orginal_path',  'cropped_path',  'quantity',  'price',  'crop_size',  'crop_left',  'crop_top',  'img_x',  'img_y',  'img_height',  'img_width',  'rotate',  'zoom'],
                    'translatable'      => ['order_id',  'orginal_path',  'cropped_path',  'quantity',  'price',  'crop_size',  'crop_left',  'crop_top',  'img_x',  'img_y',  'img_height',  'img_width',  'rotate',  'zoom'],

                    'upload-folder'     => '/uploads/order/order_item',
                    'uploadable'        => [
                                                'single'    => [],
                                                'multiple'  => [],
                                            ],
                ],
];
