<?php

namespace Apm\Order\Http\Controllers;

use App\Http\Controllers\AdminController as AdminController;
use Former;
use Apm\Order\Http\Requests\OrderAdminRequest;
use Apm\Order\Interfaces\OrderRepositoryInterface;
use Response;

/**
 * Admin controller class.
 */
class OrderAdminController extends AdminController
{
    /**
     * Initialize order controller.
     *
     * @param type OrderRepositoryInterface $order
     *
     * @return type
     */
    public function __construct(OrderRepositoryInterface $order)
    {
        $this->model = $order;
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(OrderAdminRequest $request)
    {
        if ($request->wantsJson()) {
            $array = $this->model->json();
            foreach ($array as $key => $row) {
                $array[$key] = array_only($row, config('order.order.listfields'));
            }

            return ['data' => $array];
        }

        $this->theme->prependTitle(trans('order::order.names').' :: ');

        return $this->theme->of('order::admin.order.index')->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function show(OrderAdminRequest $request, $id)
    {
        $order = $this->model->find($id);

        if (empty($order)) {
            if ($request->wantsJson()) {
                return [];
            }

            return view('order::admin.order.new');
        }

        if ($request->wantsJson()) {
            return $order;
        }

        Former::populate($order);

        return view('order::admin.order.show', compact('order'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(OrderAdminRequest $request)
    {
        $order = $this->model->findOrNew(0);
        Former::populate($order);

        return view('order::admin.order.create', compact('order'));
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(OrderAdminRequest $request)
    {
        try {
            $attributes = $request->all();
            $order = $this->model->create($attributes);

            return $this->success(trans('messages.success.created', ['Module' => trans('order::order.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function edit(OrderAdminRequest $request, $id)
    {
        $order = $this->model->find($id);

        Former::populate($order);

        return view('order::admin.order.edit', compact('order'));
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function update(OrderAdminRequest $request, $id)
    {
        try {
            $attributes = $request->all();
            $order = $this->model->update($attributes, $id);

            return $this->success(trans('messages.success.updated', ['Module' => trans('order::order.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(OrderAdminRequest $request, $id)
    {
        try {
            $this->model->delete($id);

            return $this->success(trans('message.success.deleted', ['Module' => trans('order::order.name')]), 200);
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }
}
