<?php

namespace Apm\Order\Http\Controllers;

use App\Http\Controllers\PublicController as CMSPublicController;
use Apm\Order\Interfaces\OrderRepositoryInterface;

class OrderPublicController extends CMSPublicController
{
    /**
     * Constructor.
     *
     * @param type \Apm\Order\Interfaces\OrderRepositoryInterface $order
     *
     * @return type
     */
    public function __construct(OrderRepositoryInterface $order)
    {
        $this->model = $order;
        parent::__construct();
    }

    /**
     * Show order's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $orders = $this->model->all();

        return $this->theme->of('order::public.order.index', compact('orders'))->render();
    }

    /**
     * Show order.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $order = $this->model->findBySlug($slug);

        return $this->theme->of('order::public.order.show', compact('order'))->render();
    }
}
