<?php

namespace Apm\Order\Http\Controllers;

use App\Http\Controllers\UserController as UserController;
use Former;
use Apm\Order\Http\Requests\OrderUserRequest;
use Apm\Order\Interfaces\OrderRepositoryInterface;
use Response;
use User;

class OrderUserController extends UserController
{
    /**
     * Initialize order controller.
     *
     * @param type OrderRepositoryInterface $order
     *
     * @return type
     */
    public function __construct(OrderRepositoryInterface $order)
    {
        $this->model = $order;
        $this->model->setUserFilter();
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(OrderUserRequest $request)
    {
        $orders = $this->model->all();

        $this->theme->prependTitle(trans('order::order.names').' :: ');

        return $this->theme->of('order::user.order.index', compact('orders'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function show(OrderUserRequest $request, $role, $id)
    {
        $order = $this->model->find($id);

        return $this->theme->of('order::user.order.show', compact('order'))->render();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(OrderUserRequest $request)
    {
        $order = $this->model->findOrNew(0);

        Former::populate($order);

        return $this->theme->of('order::user.order.create', compact('order'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(OrderUserRequest $request)
    {
        try {
            $attributes = $request->all();
            $order = $this->model->create($attributes);

            return $this->success(trans('messages.success.created', ['Module' => trans('order::order.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function edit(OrderUserRequest $request, $role, $id)
    {
        $order = $this->model->find($id);

        Former::populate($order);

        return $this->theme->of('order::user.order.edit', compact('order'))->render();
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param int     $id
     *
     * @return Response
     */
    public function update(OrderUserRequest $request, $role, $id)
    {
        try {
            $attributes = $request->all();
            $order = $this->model->update($attributes, $id);

            return $this->success(trans('messages.success.updated', ['Module' => trans('order::order.name')]));
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(OrderUserRequest $request, $role, $id)
    {
        try {
            $this->model->delete($id);

            return $this->success(trans('message.success.deleted', ['Module' => trans('order::order.name')]), 200);
        } catch (Exception $e) {
            return $this->error($e->getMessage());
        }
    }
}
