<?php

Route::group(['prefix' => 'admin'], function () {
    Route::resource('/order/order', 'Apm\Order\Http\Controllers\OrderAdminController');
});

// User routes for order
Route::group(['prefix' => 'user'], function () {
    Route::resource('/order/order', 'Apm\Order\Http\Controllers\OrderUserController');
});

// Public routes for order
Route::get('order/order', 'Apm\Order\Http\Controllers\OrderPublicController@index');
Route::get('order/order/{slug?}', 'Apm\Order\Http\Controllers\OrderPublicController@show');
Route::group(['prefix' => 'admin'], function () {
    Route::resource('/order/order_item', 'Apm\Order\Http\Controllers\OrderItemAdminController');
});

// User routes for order_item
Route::group(['prefix' => 'user'], function () {
    Route::resource('/order/order_item', 'Apm\Order\Http\Controllers\OrderItemUserController');
});

// Public routes for order_item
Route::get('order/order_item', 'Apm\Order\Http\Controllers\OrderItemPublicController@index');
Route::get('order/order_item/{slug?}', 'Apm\Order\Http\Controllers\OrderItemPublicController@show');
