# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/travel/00.1/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Travel\\00.1\\": "packages/travel/00.1/src",
            "Travel\\00.1\\Seeders\\": "packages/travel/00.1/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Travel\00.1\Providers\00.1ServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        '00.1'  => Travel\00.1\Facades\00.1::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Travel\\00.1\\Seeders\\00.1TableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Travel\00.1\Providers\00.1ServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Travel\00.1\Providers\00.1ServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Travel\00.1\Providers\00.1ServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/00.1/{modulename}

**User**

    http://path-to-route-folder/user/00.1/{modulename}

**Public**

    http://path-to-route-folder/00.1s


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/00.1/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/00.1/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/00.1/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/00.1/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/00.1/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/00.1/{modulename}/{slug}
    METHOD: GET