Lavalite package that provides 00.1 management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `travel/00.1`.

    "travel/00.1": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Travel\00.1\Providers\00.1ServiceProvider::class,

And also add it to alias

    '00.1'  => Travel\00.1\Facades\00.1::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Travel\\00.1\\Seeders\\00.1TableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Travel\00.1\Providers\00.1ServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Travel\00.1\Providers\00.1ServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Travel\00.1\Providers\00.1ServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/00.1/{modulename}

**User**

    http://path-to-route-folder/user/00.1/{modulename}

**Public**

    http://path-to-route-folder/00.1s


### API endpoints

**List**

    http://path-to-route-folder/api/user/00.1/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/00.1/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/00.1/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/00.1/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/00.1/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/00.1/{modulename}/{slug}
    METHOD: GET