<?php

namespace Test\Test\Http\Controllers\Api;

use App\Http\Controllers\Api\PublicController as BaseController;
use Test\Test\Interfaces\TestModuleRepositoryInterface;
use Test\Test\Repositories\Presenter\TestModuleItemTransformer;

/**
 * Pubic API controller class.
 */
class TestModulePublicController extends BaseController
{
    /**
     * Constructor.
     *
     * @param type \Test\TestModule\Interfaces\TestModuleRepositoryInterface $test_module
     *
     * @return type
     */
    public function __construct(TestModuleRepositoryInterface $test_module)
    {
        $this->repository = $test_module;
        parent::__construct();
    }

    /**
     * Show test_module's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $test_modules = $this->repository
            ->setPresenter('\\Test\\Test\\Repositories\\Presenter\\TestModuleListPresenter')
            ->scopeQuery(function($query){
                return $query->orderBy('id','DESC');
            })->paginate();

        $test_modules['code'] = 2000;
        return response()->json($test_modules)
                ->setStatusCode(200, 'INDEX_SUCCESS');
    }

    /**
     * Show test_module.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $test_module = $this->repository
            ->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        if (!is_null($test_module)) {
            $test_module         = $this->itemPresenter($module, new TestModuleItemTransformer);
            $test_module['code'] = 2001;
            return response()->json($test_module)
                ->setStatusCode(200, 'SHOW_SUCCESS');
        } else {
            return response()->json([])
                ->setStatusCode(400, 'SHOW_ERROR');
        }

    }
}
