<?php

namespace Test\Test\Http\Controllers\Api;

use App\Http\Controllers\Api\UserController as BaseController;
use Test\Test\Http\Requests\TestModuleRequest;
use Test\Test\Interfaces\TestModuleRepositoryInterface;
use Test\Test\Models\TestModule;

/**
 * User API controller class.
 */
class TestModuleUserController extends BaseController
{
    /**
     * Initialize test_module controller.
     *
     * @param type TestModuleRepositoryInterface $test_module
     *
     * @return type
     */
    public function __construct(TestModuleRepositoryInterface $test_module)
    {
        $this->repository = $test_module;
        $this->repository
                ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
                ->pushCriteria(new \Test\Test\Repositories\Criteria\TestModuleUserCriteria());
        parent::__construct();
    }

    /**
     * Display a list of test_module.
     *
     * @return json
     */
    public function index(TestModuleRequest $request)
    {
        $test_modules  = $this->repository
            ->setPresenter('\\Test\\Test\\Repositories\\Presenter\\TestModuleListPresenter')
            ->scopeQuery(function($query){
                return $query->orderBy('id','DESC');
            })->all();
        $test_modules['code'] = 2000;
        return response()->json($test_modules) 
            ->setStatusCode(200, 'INDEX_SUCCESS');

    }

    /**
     * Display test_module.
     *
     * @param Request $request
     * @param Model   TestModule
     *
     * @return Json
     */
    public function show(TestModuleRequest $request, TestModule $test_module)
    {

        if ($test_module->exists) {
            $test_module         = $test_module->presenter();
            $test_module['code'] = 2001;
            return response()->json($test_module)
                ->setStatusCode(200, 'SHOW_SUCCESS');;
        } else {
            return response()->json([])
                ->setStatusCode(400, 'SHOW_ERROR');
        }

    }

    /**
     * Show the form for creating a new test_module.
     *
     * @param Request $request
     *
     * @return json
     */
    public function create(TestModuleRequest $request, TestModule $test_module)
    {
        $test_module         = $test_module->presenter();
        $test_module['code'] = 2002;
        return response()->json($test_module)
            ->setStatusCode(200, 'CREATE_SUCCESS');
    }

    /**
     * Create new test_module.
     *
     * @param Request $request
     *
     * @return json
     */
    public function store(TestModuleRequest $request)
    {
        try {
            $attributes             = $request->all();
            $attributes['user_id']  = user_id('admin.api');
            $test_module          = $this->repository->create($attributes);
            $test_module          = $test_module->presenter();
            $test_module['code']  = 2004;

            return response()->json($test_module)
                ->setStatusCode(201, 'STORE_SUCCESS');
        } catch (Exception $e) {
            return response()->json([
                'message' => $e->getMessage(),
                'code'    => 4004,
            ])->setStatusCode(400, 'STORE_ERROR');
        }

    }

    /**
     * Show test_module for editing.
     *
     * @param Request $request
     * @param Model   $test_module
     *
     * @return json
     */
    public function edit(TestModuleRequest $request, TestModule $test_module)
    {
        if ($test_module->exists) {
            $test_module         = $test_module->presenter();
            $test_module['code'] = 2003;
            return response()-> json($test_module)
                ->setStatusCode(200, 'EDIT_SUCCESS');;
        } else {
            return response()->json([])
                ->setStatusCode(400, 'SHOW_ERROR');
        }
    }

    /**
     * Update the test_module.
     *
     * @param Request $request
     * @param Model   $test_module
     *
     * @return json
     */
    public function update(TestModuleRequest $request, TestModule $test_module)
    {
        try {

            $attributes = $request->all();

            $test_module->update($attributes);
            $test_module         = $test_module->presenter();
            $test_module['code'] = 2005;

            return response()->json($test_module)
                ->setStatusCode(201, 'UPDATE_SUCCESS');


        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 4005,
            ])->setStatusCode(400, 'UPDATE_ERROR');

        }
    }

    /**
     * Remove the test_module.
     *
     * @param Request $request
     * @param Model   $test_module
     *
     * @return json
     */
    public function destroy(TestModuleRequest $request, TestModule $test_module)
    {

        try {

            $t = $test_module->delete();

            return response()->json([
                'message'  => trans('messages.success.delete', ['Module' => trans('test::test_module.name')]),
                'code'     => 2006
            ])->setStatusCode(202, 'DESTROY_SUCCESS');

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 4006,
            ])->setStatusCode(400, 'DESTROY_ERROR');
        }
    }
}
