<?php

namespace Test\Test\Http\Controllers;

use App\Http\Controllers\AdminController as BaseController;
use Form;
use Test\Test\Http\Requests\TestModuleRequest;
use Test\Test\Interfaces\TestModuleRepositoryInterface;
use Test\Test\Models\TestModule;

/**
 * Admin web controller class.
 */
class TestModuleAdminController extends BaseController
{
    // use TestModuleWorkflow;
    /**
     * Initialize test_module controller.
     *
     * @param type TestModuleRepositoryInterface $test_module
     *
     * @return type
     */
    public function __construct(TestModuleRepositoryInterface $test_module)
    {
        $this->repository = $test_module;
        parent::__construct();
    }

    /**
     * Display a list of test_module.
     *
     * @return Response
     */
    public function index(TestModuleRequest $request)
    {
        if ($request->wantsJson()) {
            return $this->getJson($request);
        }
        $this   ->theme->prependTitle(trans('test::test_module.names').' :: ');
        return $this->theme->of('test::admin.test_module.index')->render();
    }

    /**
     * Display a list of test_module.
     *
     * @return Response
     */
    public function getJson(TestModuleRequest $request)
    {
        $pageLimit = $request->input('pageLimit');

        $test_modules  = $this->repository
                ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
                ->setPresenter('\\Test\\Test\\Repositories\\Presenter\\TestModuleListPresenter')
                ->scopeQuery(function($query){
                    return $query->orderBy('id','DESC');
                })->paginate($pageLimit);
        $test_modules['recordsTotal']    = $test_modules['meta']['pagination']['total'];
        $test_modules['recordsFiltered'] = $test_modules['meta']['pagination']['total'];
        $test_modules['request']         = $request->all();
        return response()->json($test_modules, 200);

    }

    /**
     * Display test_module.
     *
     * @param Request $request
     * @param Model   $test_module
     *
     * @return Response
     */
    public function show(TestModuleRequest $request, TestModule $test_module)
    {
        if (!$test_module->exists) {
            return response()->view('test::admin.test_module.new', compact('test_module'));
        }

        Form::populate($test_module);
        return response()->view('test::admin.test_module.show', compact('test_module'));
    }

    /**
     * Show the form for creating a new test_module.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(TestModuleRequest $request)
    {

        $test_module = $this->repository->newInstance([]);

        Form::populate($test_module);

        return response()->view('test::admin.test_module.create', compact('test_module'));

    }

    /**
     * Create new test_module.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(TestModuleRequest $request)
    {
        try {
            $attributes             = $request->all();
            $attributes['user_id']  = user_id('admin.web');
            $test_module          = $this->repository->create($attributes);

            return response()->json([
                'message'  => trans('messages.success.updated', ['Module' => trans('test::test_module.name')]),
                'code'     => 204,
                'redirect' => trans_url('/admin/test/test_module/'.$test_module->getRouteKey())
            ], 201);


        } catch (Exception $e) {
            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
            ], 400);
        }
    }

    /**
     * Show test_module for editing.
     *
     * @param Request $request
     * @param Model   $test_module
     *
     * @return Response
     */
    public function edit(TestModuleRequest $request, TestModule $test_module)
    {
        Form::populate($test_module);
        return  response()->view('test::admin.test_module.edit', compact('test_module'));
    }

    /**
     * Update the test_module.
     *
     * @param Request $request
     * @param Model   $test_module
     *
     * @return Response
     */
    public function update(TestModuleRequest $request, TestModule $test_module)
    {
        try {

            $attributes = $request->all();

            $test_module->update($attributes);

            return response()->json([
                'message'  => trans('messages.success.updated', ['Module' => trans('test::test_module.name')]),
                'code'     => 204,
                'redirect' => trans_url('/admin/test/test_module/'.$test_module->getRouteKey())
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/test/test_module/'.$test_module->getRouteKey()),
            ], 400);

        }
    }

    /**
     * Remove the test_module.
     *
     * @param Model   $test_module
     *
     * @return Response
     */
    public function destroy(TestModuleRequest $request, TestModule $test_module)
    {

        try {

            $t = $test_module->delete();

            return response()->json([
                'message'  => trans('messages.success.deleted', ['Module' => trans('test::test_module.name')]),
                'code'     => 202,
                'redirect' => trans_url('/admin/test/test_module/0'),
            ], 202);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/test/test_module/'.$test_module->getRouteKey()),
            ], 400);
        }
    }

}
