<?php

namespace Test\Test\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Test\Test\Interfaces\TestModuleRepositoryInterface;

class TestModulePublicController extends BaseController
{
    // use TestModuleWorkflow;

    /**
     * Constructor.
     *
     * @param type \Test\TestModule\Interfaces\TestModuleRepositoryInterface $test_module
     *
     * @return type
     */
    public function __construct(TestModuleRepositoryInterface $test_module)
    {
        $this->repository = $test_module;
        parent::__construct();
    }

    /**
     * Show test_module's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $test_modules = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();

        return $this->theme->of('test::public.test_module.index', compact('test_modules'))->render();
    }

    /**
     * Show test_module.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $test_module = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->theme->of('test::public.test_module.show', compact('test_module'))->render();
    }

}
