<?php

namespace Test\Test\Http\Controllers;

use App\Http\Controllers\UserController as BaseController;
use Form;
use Test\Test\Http\Requests\TestModuleRequest;
use Test\Test\Interfaces\TestModuleRepositoryInterface;
use Test\Test\Models\TestModule;

class TestModuleUserController extends BaseController
{
    /**
     * Initialize test_module controller.
     *
     * @param type TestModuleRepositoryInterface $test_module
     *
     * @return type
     */
    public function __construct(TestModuleRepositoryInterface $test_module)
    {
        $this->repository = $test_module;
        $this->repository
                ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
                ->pushCriteria(new \Test\Test\Repositories\Criteria\TestModuleUserCriteria());
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(TestModuleRequest $request)
    {
        $test_modules = $this->repository->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();

        $this->theme->prependTitle(trans('test::test_module.names'));

        return $this->theme->of('test::user.test_module.index', compact('test_modules'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param TestModule $test_module
     *
     * @return Response
     */
    public function show(TestModuleRequest $request, TestModule $test_module)
    {
        Form::populate($test_module);

        return $this->theme->of('test::user.test_module.show', compact('test_module'))->render();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(TestModuleRequest $request)
    {

        $test_module = $this->repository->newInstance([]);
        Form::populate($test_module);

        $this->theme->prependTitle(trans('test::test_module.names'));
        return $this->theme->of('test::user.test_module.create', compact('test_module'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(TestModuleRequest $request)
    {
        try {
            $attributes = $request->all();
            $attributes['user_id'] = user_id();
            $test_module = $this->repository->create($attributes);

            return redirect(trans_url('/user/test/test_module'))
                -> with('message', trans('messages.success.created', ['Module' => trans('test::test_module.name')]))
                -> with('code', 201);

        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param TestModule $test_module
     *
     * @return Response
     */
    public function edit(TestModuleRequest $request, TestModule $test_module)
    {

        Form::populate($test_module);
        $this->theme->prependTitle(trans('test::test_module.names'));

        return $this->theme->of('test::user.test_module.edit', compact('test_module'))->render();
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param TestModule $test_module
     *
     * @return Response
     */
    public function update(TestModuleRequest $request, TestModule $test_module)
    {
        try {
            $this->repository->update($request->all(), $test_module->getRouteKey());

            return redirect(trans_url('/user/test/test_module'))
                ->with('message', trans('messages.success.updated', ['Module' => trans('test::test_module.name')]))
                ->with('code', 204);

        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(TestModuleRequest $request, TestModule $test_module)
    {
        try {
            $this->repository->delete($test_module->getRouteKey());
            return redirect(trans_url('/user/test/test_module'))
                ->with('message', trans('messages.success.deleted', ['Module' => trans('test::test_module.name')]))
                ->with('code', 204);

        } catch (Exception $e) {

            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);

        }
    }
}
