<?php

namespace Test\Test\Http\Controllers;
use Litepie\Test\Http\Requests\TestModuleRequest;
use Litepie\Test\Models\TestModule;

trait TestModuleWorkflow {
	
    /**
     * Workflow controller function for test_module.
     *
     * @param Model   $test_module
     * @param step    next step for the workflow.
     *
     * @return Response
     */

    public function putWorkflow(TestModuleRequest $request, TestModule $test_module, $step)
    {

        try {

            $test_module->updateWorkflow($step);

            return response()->json([
                'message'  => trans('messages.success.changed', ['Module' => trans('test::test_module.name'), 'status' => trans("app.{$step}")]),
                'code'     => 204,
                'redirect' => trans_url('/admin/test_module/test_module/' . $test_module->getRouteKey()),
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/test_module/test_module/' . $test_module->getRouteKey()),
            ], 400);

        }

    }

    /**
     * Workflow controller function for test_module.
     *
     * @param Model   $test_module
     * @param step    next step for the workflow.
     * @param user    encrypted user id.
     *
     * @return Response
    */

    public function getWorkflow(TestModule $test_module, $step, $user)
    {
        try {
            $user_id = decrypt($user);

            Auth::onceUsingId($user_id);

            $test_module->updateWorkflow($step);

            $data = [
                'message' => trans('messages.success.changed', ['Module' => trans('test::test_module.name'), 'status' => trans("app.{$step}")]),
                'status'  => 'success',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('test::admin.test_module.message', $data)->render();

        } catch (ValidationException $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b> <br /><br />' . implode('<br />', $e->validator->errors()->all()),
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('test::admin.test_module.message', $data)->render();

        } catch (Exception $e) {

            $data = [
                'message' => '<b>' . $e->getMessage(). '</b>',
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('test::admin.test_module.message', $data)->render();

        }

    }
}