<?php

namespace Test\Test\Policies;

use App\User;
use Test\Test\Models\TestModule;

class TestModulePolicy
{

    /**
     * Determine if the given user can view the test_module.
     *
     * @param User $user
     * @param TestModule $test_module
     *
     * @return bool
     */
    public function view(User $user, TestModule $test_module)
    {
        if ($user->canDo('test.test_module.view') && $user->is('admin')) {
            return true;
        }

        if ($user->canDo('blocks.block.view') 
        && $user->is('manager')
        && $block->user->parent_id == $user->id) {
            return true;
        }

        return $user->id === $test_module->user_id;
    }

    /**
     * Determine if the given user can create a test_module.
     *
     * @param User $user
     * @param TestModule $test_module
     *
     * @return bool
     */
    public function create(User $user)
    {
        return  $user->canDo('test.test_module.create');
    }

    /**
     * Determine if the given user can update the given test_module.
     *
     * @param User $user
     * @param TestModule $test_module
     *
     * @return bool
     */
    public function update(User $user, TestModule $test_module)
    {
        if ($user->canDo('test.test_module.update') && $user->is('admin')) {
            return true;
        }

        if ($user->canDo('blocks.block.update') 
        && $user->is('manager')
        && $block->user->parent_id == $user->id) {
            return true;
        }

        return $user->id === $test_module->user_id;
    }

    /**
     * Determine if the given user can delete the given test_module.
     *
     * @param User $user
     * @param TestModule $test_module
     *
     * @return bool
     */
    public function destroy(User $user, TestModule $test_module)
    {
        if ($user->canDo('test.test_module.delete') && $user->is('admin')) {
            return true;
        }

        if ($user->canDo('blocks.block.delete') 
        && $user->is('manager')
        && $block->user->parent_id == $user->id) {
            return true;
        }

        return $user->id === $test_module->user_id;
    }

    /**
     * Determine if the given user can verify the given test_module.
     *
     * @param User $user
     * @param TestModule $test_module
     *
     * @return bool
     */
    public function verify(User $user, TestModule $test_module)
    {
        if ($user->canDo('test.test_module.verify') && $user->is('admin')) {
            return true;
        }

        if ($user->canDo('test.test_module.verify') 
        && $user->is('manager')
        && $test_module->user->parent_id == $user->id) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given test_module.
     *
     * @param User $user
     * @param TestModule $test_module
     *
     * @return bool
     */
    public function approve(User $user, TestModule $test_module)
    {
        if ($user->canDo('test.test_module.approve') && $user->is('admin')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperUser()) {
            return true;
        }
    }
}
