<?php

namespace Test\Test;

use User;

class Test
{
    /**
     * $test_module object.
     */
    protected $test_module;

    /**
     * Constructor.
     */
    public function __construct(\Test\Test\Interfaces\TestModuleRepositoryInterface $test_module)
    {
        $this->test_module = $test_module;
    }

    /**
     * Returns count of test.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.test_module.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->test_module->pushCriteria(new \Litepie\Test\Repositories\Criteria\TestModuleUserCriteria());
        }

        $test_module = $this->test_module->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('test::' . $view, compact('test_module'))->render();
    }
}
