<?php

namespace Test\Test\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Test\Test\Models\TestModule;

class TestModuleAction
{
    /**
     * Perform the complete action.
     *
     * @param TestModule $test_module
     *
     * @return TestModule
     */
    public function complete(TestModule $test_module)
    {
        try {
            $test_module->status = 'complete';
            return $test_module->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param TestModule $test_module
     *
     * @return TestModule
     */public function verify(TestModule $test_module)
    {
        try {
            $test_module->status = 'verify';
            return $test_module->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param TestModule $test_module
     *
     * @return TestModule
     */public function approve(TestModule $test_module)
    {
        try {
            $test_module->status = 'approve';
            return $test_module->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param TestModule $test_module
     *
     * @return TestModule
     */public function publish(TestModule $test_module)
    {
        try {
            $test_module->status = 'publish';
            return $test_module->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param TestModule $test_module
     *
     * @return TestModule
     */
    public function archive(TestModule $test_module)
    {
        try {
            $test_module->status = 'archive';
            return $test_module->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param TestModule $test_module
     *
     * @return TestModule
     */
    public function unpublish(TestModule $test_module)
    {
        try {
            $test_module->status = 'unpublish';
            return $test_module->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
