<?php

namespace Test\Test\Workflow;

use Test\Test\Models\TestModule;
use Test\Test\Notifications\TestModule as TestModuleNotifyer;
use Notification;

class TestModuleNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param TestModule $test_module
     *
     * @return void
     */
    public function complete(TestModule $test_module)
    {
        return Notification::send($test_module->user, new TestModuleNotifyer($test_module, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param TestModule $test_module
     *
     * @return void
     */
    public function verify(TestModule $test_module)
    {
        return Notification::send($test_module->user, new TestModuleNotifyer($test_module, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param TestModule $test_module
     *
     * @return void
     */
    public function approve(TestModule $test_module)
    {
        return Notification::send($test_module->user, new TestModuleNotifyer($test_module, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param TestModule $test_module
     *
     * @return void
     */
    public function publish(TestModule $test_module)
    {
        return Notification::send($test_module->user, new TestModuleNotifyer($test_module, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param TestModule $test_module
     *
     * @return void
     */
    public function archive(TestModule $test_module)
    {
        return Notification::send($test_module->user, new TestModuleNotifyer($test_module, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param TestModule $test_module
     *
     * @return void
     */
    public function unpublish(TestModule $test_module)
    {
        return Notification::send($test_module->user, new TestModuleNotifyer($test_module, 'unpublish'));;

    }
}
