<?php

namespace Test\Test\Workflow;

use Test\Test\Models\TestModule;
use Validator;

class TestModuleValidator
{

    /**
     * Determine if the given test_module is valid for complete status.
     *
     * @param TestModule $test_module
     *
     * @return bool / Validator
     */
    public function complete(TestModule $test_module)
    {
        return Validator::make($test_module->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given test_module is valid for verify status.
     *
     * @param TestModule $test_module
     *
     * @return bool / Validator
     */
    public function verify(TestModule $test_module)
    {
        return Validator::make($test_module->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given test_module is valid for approve status.
     *
     * @param TestModule $test_module
     *
     * @return bool / Validator
     */
    public function approve(TestModule $test_module)
    {
        return Validator::make($test_module->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given test_module is valid for publish status.
     *
     * @param TestModule $test_module
     *
     * @return bool / Validator
     */
    public function publish(TestModule $test_module)
    {
        return Validator::make($test_module->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given test_module is valid for archive status.
     *
     * @param TestModule $test_module
     *
     * @return bool / Validator
     */
    public function archive(TestModule $test_module)
    {
        return Validator::make($test_module->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given test_module is valid for unpublish status.
     *
     * @param TestModule $test_module
     *
     * @return bool / Validator
     */
    public function unpublish(TestModule $test_module)
    {
        return Validator::make($test_module->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
