<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateEscrowDetailsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: escrow_details
         */
        Schema::create('escrow_details', function ($table) {
            $table->increments('id');
            $table->integer('escrow_id')->nullable();
            $table->date('date')->nullable();
            $table->string('description', 255)->nullable();
            $table->decimal('amount', 12,3)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('escrow_details');
    }
}
