<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateEscrowsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: escrows
         */
        Schema::create('escrows', function ($table) {
            $table->increments('id');
            $table->integer('agent')->nullable();
            $table->integer('location_id')->nullable();
            $table->integer('sublocation_id')->nullable();
            $table->integer('building_id')->nullable();
            $table->text('documents')->nullable();
            $table->string('notes', 255)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('escrows');
    }
}
