<?php

namespace Bixo\Account;

use DB;
use Illuminate\Database\Seeder;

class EscrowTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('escrows')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'account.escrow.view',
                'name'      => 'View Escrow',
            ],
            [
                'slug'      => 'account.escrow.create',
                'name'      => 'Create Escrow',
            ],
            [
                'slug'      => 'account.escrow.edit',
                'name'      => 'Update Escrow',
            ],
            [
                'slug'      => 'account.escrow.delete',
                'name'      => 'Delete Escrow',
            ],
            
            // Customize this permissions if needed.
            [
                'slug'      => 'account.escrow.verify',
                'name'      => 'Verify Escrow',
            ],
            [
                'slug'      => 'account.escrow.approve',
                'name'      => 'Approve Escrow',
            ],
            [
                'slug'      => 'account.escrow.publish',
                'name'      => 'Publish Escrow',
            ],
            [
                'slug'      => 'account.escrow.unpublish',
                'name'      => 'Unpublish Escrow',
            ],
            [
                'slug'      => 'account.escrow.cancel',
                'name'      => 'Cancel Escrow',
            ],
            [
                'slug'      => 'account.escrow.archive',
                'name'      => 'Archive Escrow',
            ],
            
        ]);

        DB::table('menus')->insert([

            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/account/escrow',
                'name'        => 'Escrow',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/account/escrow',
                'name'        => 'Escrow',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'escrow',
                'name'        => 'Escrow',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Account',
                'module'    => 'Escrow',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'account.escrow.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
