# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/bixo/account/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/bixo/account/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Bixo\\Account\\": "packages/bixo/account/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Bixo\Account\Providers\AccountServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Account'  => Bixo\Account\Facades\Account::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Bixo\\AccountTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Bixo\Account\Providers\AccountServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Bixo\Account\Providers\AccountServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Bixo\Account\Providers\AccountServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/account/{modulename}

**User**

    http://path-to-route-folder/user/account/{modulename}

**Public**

    http://path-to-route-folder/accounts


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/account/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/account/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/account/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/account/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/account/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/account/{modulename}/{slug}
    METHOD: GET