Lavalite package that provides account management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `bixo/account`.

    "bixo/account": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Bixo\Account\Providers\AccountServiceProvider::class,

And also add it to alias

    'Account'  => Bixo\Account\Facades\Account::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Bixo\\AccountTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Bixo\Account\Providers\AccountServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Bixo\Account\Providers\AccountServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Bixo\Account\Providers\AccountServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/account/{modulename}

**User**

    http://path-to-route-folder/user/account/{modulename}

**Public**

    http://path-to-route-folder/accounts


### API endpoints

**List**

    http://path-to-route-folder/api/user/account/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/account/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/account/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/account/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/account/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/account/{modulename}/{slug}
    METHOD: GET