<?php

// API routes  for escrow
Route::prefix('{guard}/account')->group(function () {
    Route::get('escrow/form/{element}', 'EscrowAPIController@form');
    Route::resource('escrow', 'EscrowAPIController');
});

// Public routes for escrow
Route::get('accounts/', 'EscrowPublicController@index');
Route::get('accounts/{slug?}', 'EscrowPublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for accounts
            Route::prefix('{guard}/account')->group(function () {
                Route::get('escrow/form/{element}', 'EscrowAPIController@form');
                Route::apiResource('escrow', 'EscrowAPIController');
            });
            // Public routes for accounts
            Route::get('account/Escrow', 'EscrowPublicController@getEscrow');
        }
    );
}

// API routes  for escrow_details
Route::prefix('{guard}/account')->group(function () {
    Route::get('escrow_details/form/{element}', 'EscrowDetailsAPIController@form');
    Route::resource('escrow_details', 'EscrowDetailsAPIController');
});

// Public routes for escrow_details
Route::get('accounts/', 'EscrowDetailsPublicController@index');
Route::get('accounts/{slug?}', 'EscrowDetailsPublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for accounts
            Route::prefix('{guard}/account')->group(function () {
                Route::get('escrow_details/form/{element}', 'EscrowDetailsAPIController@form');
                Route::apiResource('escrow_details', 'EscrowDetailsAPIController');
            });
            // Public routes for accounts
            Route::get('account/EscrowDetails', 'EscrowDetailsPublicController@getEscrowDetails');
        }
    );
}

