<?php

// web routes  for escrow
Route::prefix('{guard}/account')->group(function () {
    Route::resource('escrow', 'EscrowResourceController');
});

// Public routes for escrow
Route::get('accounts/', 'EscrowPublicController@index');
Route::get('accounts/{slug?}', 'EscrowPublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'EscrowResourceController');
            });
            // Public routes for pages
            Route::get('accounts/', 'EscrowPublicController@index');
            Route::get('accounts/{slug?}', 'EscrowPublicController@show');
        }
    );
}

// web routes  for escrow_details
Route::prefix('{guard}/account')->group(function () {
    Route::resource('escrow_details', 'EscrowDetailsResourceController');
});

// Public routes for escrow_details
Route::get('accounts/', 'EscrowDetailsPublicController@index');
Route::get('accounts/{slug?}', 'EscrowDetailsPublicController@show');

if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'EscrowDetailsResourceController');
            });
            // Public routes for pages
            Route::get('accounts/', 'EscrowDetailsPublicController@index');
            Route::get('accounts/{slug?}', 'EscrowDetailsPublicController@show');
        }
    );
}

