<?php

namespace Bixo\Account;

use User;

class Account
{
    /**
     * $escrow object.
     */
    protected $escrow;    /**
     * $escrow_details object.
     */
    protected $escrow_details;

    /**
     * Constructor.
     */
    public function __construct(\Bixo\Account\Interfaces\EscrowRepositoryInterface $escrow,        \Bixo\Account\Interfaces\EscrowDetailsRepositoryInterface $escrow_details)
    {
        $this->escrow = $escrow;        $this->escrow_details = $escrow_details;
    }

    /**
     * Returns count of account.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.escrow.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->escrow->pushCriteria(new \Litepie\Bixo\Repositories\Criteria\EscrowUserCriteria());
        }

        $escrow = $this->escrow->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('account::' . $view, compact('escrow'))->render();
    }    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.escrow_details.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->escrow_details->pushCriteria(new \Litepie\Bixo\Repositories\Criteria\EscrowDetailsUserCriteria());
        }

        $escrow_details = $this->escrow_details->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('account::' . $view, compact('escrow_details'))->render();
    }
}
