<?php

namespace Bixo\Account\Forms;

class Escrow
{
    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $form;

    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $element;

    /**
     * Initialize the form.
     *
     * @return null
     */
    public function __construct()
    {
        $this->setForm();
    }

    /**
     * Return form elements.
     *
     * @return array.
     */
    public function form($element = 'fields', $grouped = true)
    {
        $item = collect($this->form->get($element));
        if ($element == 'fields' && $grouped == true) {
            return $item->groupBy(['group', 'section']);
        }
        return $item;

    }

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public function setForm()
    {
        $this->form = collect([
            'form' => [
                'store' => [],
                'update' => [],
            ],
            'groups' => [
                'main' => 'Main',
            ],
            'fields' => [
                'agent' => [
                    "type" => 'numeric',
                    "label" => trans('account::escrow.label.agent'),
                    "placeholder" => trans('account::escrow.placeholder.agent'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'location_id' => [
                    "type" => 'numeric',
                    "label" => trans('account::escrow.label.location_id'),
                    "placeholder" => trans('account::escrow.placeholder.location_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'sublocation_id' => [
                    "type" => 'numeric',
                    "label" => trans('account::escrow.label.sublocation_id'),
                    "placeholder" => trans('account::escrow.placeholder.sublocation_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'building_id' => [
                    "type" => 'numeric',
                    "label" => trans('account::escrow.label.building_id'),
                    "placeholder" => trans('account::escrow.placeholder.building_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'documents' => [
                    "type" => 'text',
                    "label" => trans('account::escrow.label.documents'),
                    "placeholder" => trans('account::escrow.placeholder.documents'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'notes' => [
                    "type" => 'text',
                    "label" => trans('account::escrow.label.notes'),
                    "placeholder" => trans('account::escrow.placeholder.notes'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
            ]
        );

    }
}
