<?php

namespace Bixo\Account\Forms;

class EscrowDetails
{
    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $form;

    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $element;

    /**
     * Initialize the form.
     *
     * @return null
     */
    public function __construct()
    {
        $this->setForm();
    }

    /**
     * Return form elements.
     *
     * @return array.
     */
    public function form($element = 'fields', $grouped = true)
    {
        $item = collect($this->form->get($element));
        if ($element == 'fields' && $grouped == true) {
            return $item->groupBy(['group', 'section']);
        }
        return $item;

    }

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public function setForm()
    {
        $this->form = collect([
            'form' => [
                'store' => [],
                'update' => [],
            ],
            'groups' => [
                'main' => 'Main',
            ],
            'fields' => [
                'escrow_id' => [
                    "type" => 'numeric',
                    "label" => trans('account::escrow_details.label.escrow_id'),
                    "placeholder" => trans('account::escrow_details.placeholder.escrow_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'date' => [
                    "type" => 'date_picker',
                    "label" => trans('account::escrow_details.label.date'),
                    "placeholder" => trans('account::escrow_details.placeholder.date'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'description' => [
                    "type" => 'text',
                    "label" => trans('account::escrow_details.label.description'),
                    "placeholder" => trans('account::escrow_details.placeholder.description'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'amount' => [
                    "type" => 'decimal',
                    "label" => trans('account::escrow_details.label.amount'),
                    "placeholder" => trans('account::escrow_details.placeholder.amount'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
            ]
        );

    }
}
