<?php

namespace Bixo\Account\Http\Controllers;

use App\Http\Controllers\APIController as BaseController;
use Bixo\Account\Http\Requests\EscrowDetailsRequest;
use Bixo\Account\Interfaces\EscrowDetailsRepositoryInterface;
use Bixo\Account\Models\EscrowDetails;
use Bixo\Account\Forms\EscrowDetails as Form;

/**
 * APIController  class for escrow_details.
 */
class EscrowDetailsAPIController extends BaseController
{

    /**
     * Initialize escrow_details resource controller.
     *
     * @param type EscrowDetailsRepositoryInterface $escrow_details
     *
     * @return null
     */
    public function __construct(EscrowDetailsRepositoryInterface $escrow_details)
    {
        parent::__construct();
        $this->repository = $escrow_details;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Bixo\Account\Repositories\Criteria\EscrowDetailsResourceCriteria::class);
    }

    /**
     * Display a list of escrow_details.
     *
     * @return Response
     */
    public function index(EscrowDetailsRequest $request)
    {
        return $this->repository
            ->setPresenter(\Bixo\Account\Repositories\Presenter\EscrowDetailsPresenter::class)
            ->paginate();
    }

    /**
     * Display escrow_details.
     *
     * @param Request $request
     * @param Model   $escrow_details
     *
     * @return Response
     */
    public function show(EscrowDetailsRequest $request, EscrowDetails $escrow_details)
    {
        return $escrow_details->setPresenter(\Bixo\Account\Repositories\Presenter\EscrowDetailsListPresenter::class);
        ;
    }

    /**
     * Create new escrow_details.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(EscrowDetailsRequest $request)
    {
        try {
            $data              = $request->all();
            $data['user_id']   = user_id();
            $data['user_type'] = user_type();
            $data              = $this->repository->create($data);
            $message           = trans('messages.success.created', ['Module' => trans('account::escrow_details.name')]);
            $code              = 204;
            $status            = 'success';
            $url               = guard_url('account/escrow_details/' . $escrow_details->getRouteKey());
        } catch (Exception $e) {
            $message = $e->getMessage();
            $code    = 400;
            $status  = 'error';
            $url     = guard_url('account/escrow_details');
        }
        return compact('data', 'message', 'code', 'status', 'url');
    }

    /**
     * Update the escrow_details.
     *
     * @param Request $request
     * @param Model   $escrow_details
     *
     * @return Response
     */
    public function update(EscrowDetailsRequest $request, EscrowDetails $escrow_details)
    {
        try {
            $data = $request->all();

            $escrow_details->update($data);
            $message = trans('messages.success.updated', ['Module' => trans('account::escrow_details.name')]);
            $code    = 204;
            $status  = 'success';
            $url     = guard_url('account/escrow_details/' . $escrow_details->getRouteKey());
        } catch (Exception $e) {
            $message = $e->getMessage();
            $code    = 400;
            $status  = 'error';
            $url     = guard_url('account/escrow_details/' . $escrow_details->getRouteKey());
        }
        return compact('data', 'message', 'code', 'status', 'url');
    }

    /**
     * Remove the escrow_details.
     *
     * @param Model   $escrow_details
     *
     * @return Response
     */
    public function destroy(EscrowDetailsRequest $request, EscrowDetails $escrow_details)
    {
        try {
            $escrow_details->delete();
            $message = trans('messages.success.deleted', ['Module' => trans('account::escrow_details.name')]);
            $code    = 202;
            $status  = 'success';
            $url     = guard_url('account/escrow_details/0');
        } catch (Exception $e) {
            $message = $e->getMessage();
            $code    = 400;
            $status  = 'error';
            $url     = guard_url('account/escrow_details/' . $escrow_details->getRouteKey());
        }
        return compact('message', 'code', 'status', 'url');
    }

    /**
     * Return the form elements as json.
     *
     * @param String   $element
     *
     * @return json
     */
    public function form($element = 'fields')
    {
        $form = new Form();
        return $form->form($element, true);
    }

}
