<?php

namespace Bixo\Account\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Bixo\Account\Interfaces\EscrowDetailsRepositoryInterface;

class EscrowDetailsPublicController extends BaseController
{
    // use EscrowDetailsWorkflow;

    /**
     * Constructor.
     *
     * @param type \Bixo\EscrowDetails\Interfaces\EscrowDetailsRepositoryInterface $escrow_details
     *
     * @return type
     */
    public function __construct(EscrowDetailsRepositoryInterface $escrow_details)
    {
        $this->repository = $escrow_details;
        parent::__construct();
    }

    /**
     * Show escrow_details's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $escrow_details = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->setMetaTitle(trans('account::escrow_details.names'))
            ->view('account::public.escrow_details.index')
            ->data(compact('escrow_details'))
            ->output();
    }


    /**
     * Show escrow_details.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $escrow_details = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->setMetaTitle($escrow_details->name . trans('account::escrow_details.name'))
            ->view('account::public.escrow_details.show')
            ->data(compact('escrow_details'))
            ->output();
    }

}
