<?php

namespace Bixo\Account\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Bixo\Account\Interfaces\EscrowRepositoryInterface;

class EscrowPublicController extends BaseController
{
    // use EscrowWorkflow;

    /**
     * Constructor.
     *
     * @param type \Bixo\Escrow\Interfaces\EscrowRepositoryInterface $escrow
     *
     * @return type
     */
    public function __construct(EscrowRepositoryInterface $escrow)
    {
        $this->repository = $escrow;
        parent::__construct();
    }

    /**
     * Show escrow's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $escrows = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->setMetaTitle(trans('account::escrow.names'))
            ->view('account::public.escrow.index')
            ->data(compact('escrows'))
            ->output();
    }


    /**
     * Show escrow.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $escrow = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->setMetaTitle($escrow->name . trans('account::escrow.name'))
            ->view('account::public.escrow.show')
            ->data(compact('escrow'))
            ->output();
    }

}
