<?php

namespace Bixo\Account\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use Bixo\Account\Http\Requests\EscrowRequest;
use Bixo\Account\Models\Escrow;

/**
 * Admin web controller class.
 */
class EscrowWorkflowController extends BaseController
{

    /**
     * Workflow controller function for escrow.
     *
     * @param Model   $escrow
     * @param step    next step for the workflow.
     *
     * @return Response
     */

    public function putWorkflow(EscrowRequest $request, Escrow $escrow, $step)
    {

        try {

            $escrow->updateWorkflow($step);

            return response()->json([
                'message'  => trans('messages.success.changed', ['Module' => trans('account::escrow.name'), 'status' => trans("app.{$step}")]),
                'code'     => 204,
                'redirect' => trans_url('/admin/escrow/escrow/' . $escrow->getRouteKey()),
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/escrow/escrow/' . $escrow->getRouteKey()),
            ], 400);

        }

    }

    /**
     * Workflow controller function for escrow.
     *
     * @param Model   $escrow
     * @param step    next step for the workflow.
     * @param user    encrypted user id.
     *
     * @return Response
     */

    public function getWorkflow(Escrow $escrow, $step, $user)
    {
        try {
            $user_id = decrypt($user);

            Auth::onceUsingId($user_id);

            $escrow->updateWorkflow($step);

            $data = [
                'message' => trans('messages.success.changed', ['Module' => trans('account::escrow.name'), 'status' => trans("app.{$step}")]),
                'status'  => 'success',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('account::admin.escrow.message', $data)->render();

        } catch (ValidationException $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b> <br /><br />' . implode('<br />', $e->validator->errors()->all()),
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('account::admin.escrow.message', $data)->render();

        } catch (Exception $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b>',
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('account::admin.escrow.message', $data)->render();

        }

    }
}
