<?php

namespace Bixo\Account\Policies;

use Litepie\User\Contracts\UserPolicy;
use Bixo\Account\Models\EscrowDetails;

class EscrowDetailsPolicy
{

    /**
     * Determine if the given user can view the escrow_details.
     *
     * @param UserPolicy $user
     * @param EscrowDetails $escrow_details
     *
     * @return bool
     */
    public function view(UserPolicy $user, EscrowDetails $escrow_details)
    {
        if ($user->canDo('account.escrow_details.view') && $user->isAdmin()) {
            return true;
        }

        return $escrow_details->user_id == user_id() && $escrow_details->user_type == user_type();
    }

    /**
     * Determine if the given user can create a escrow_details.
     *
     * @param UserPolicy $user
     * @param EscrowDetails $escrow_details
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('account.escrow_details.create');
    }

    /**
     * Determine if the given user can update the given escrow_details.
     *
     * @param UserPolicy $user
     * @param EscrowDetails $escrow_details
     *
     * @return bool
     */
    public function update(UserPolicy $user, EscrowDetails $escrow_details)
    {
        if ($user->canDo('account.escrow_details.edit') && $user->isAdmin()) {
            return true;
        }

        return $escrow_details->user_id == user_id() && $escrow_details->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given escrow_details.
     *
     * @param UserPolicy $user
     * @param EscrowDetails $escrow_details
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, EscrowDetails $escrow_details)
    {
        return $escrow_details->user_id == user_id() && $escrow_details->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given escrow_details.
     *
     * @param UserPolicy $user
     * @param EscrowDetails $escrow_details
     *
     * @return bool
     */
    public function verify(UserPolicy $user, EscrowDetails $escrow_details)
    {
        if ($user->canDo('account.escrow_details.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given escrow_details.
     *
     * @param UserPolicy $user
     * @param EscrowDetails $escrow_details
     *
     * @return bool
     */
    public function approve(UserPolicy $user, EscrowDetails $escrow_details)
    {
        if ($user->canDo('account.escrow_details.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
