<?php

namespace Bixo\Account\Policies;

use Litepie\User\Contracts\UserPolicy;
use Bixo\Account\Models\Escrow;

class EscrowPolicy
{

    /**
     * Determine if the given user can view the escrow.
     *
     * @param UserPolicy $user
     * @param Escrow $escrow
     *
     * @return bool
     */
    public function view(UserPolicy $user, Escrow $escrow)
    {
        if ($user->canDo('account.escrow.view') && $user->isAdmin()) {
            return true;
        }

        return $escrow->user_id == user_id() && $escrow->user_type == user_type();
    }

    /**
     * Determine if the given user can create a escrow.
     *
     * @param UserPolicy $user
     * @param Escrow $escrow
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('account.escrow.create');
    }

    /**
     * Determine if the given user can update the given escrow.
     *
     * @param UserPolicy $user
     * @param Escrow $escrow
     *
     * @return bool
     */
    public function update(UserPolicy $user, Escrow $escrow)
    {
        if ($user->canDo('account.escrow.edit') && $user->isAdmin()) {
            return true;
        }

        return $escrow->user_id == user_id() && $escrow->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given escrow.
     *
     * @param UserPolicy $user
     * @param Escrow $escrow
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Escrow $escrow)
    {
        return $escrow->user_id == user_id() && $escrow->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given escrow.
     *
     * @param UserPolicy $user
     * @param Escrow $escrow
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Escrow $escrow)
    {
        if ($user->canDo('account.escrow.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given escrow.
     *
     * @param UserPolicy $user
     * @param Escrow $escrow
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Escrow $escrow)
    {
        if ($user->canDo('account.escrow.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
