<?php

namespace Bixo\Account\Providers;

use Illuminate\Support\ServiceProvider;

class AccountServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'account');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'account');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerAccount();
        $this->registerFacade();
        $this->registerBindings();
        //$this->registerCommands();
    }


    /**
     * Register the application bindings.
     *
     * @return void
     */
    protected function registerAccount()
    {
        $this->app->bind('account', function($app) {
            return new Account($app);
        });
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->booting(function()
        {
            $loader = \Illuminate\Foundation\AliasLoader::getInstance();
            $loader->alias('Account', 'Lavalite\Account\Facades\Account');
        });
    }

    /**
     * Register bindings for the provider.
     *
     * @return void
     */
    public function registerBindings() {
        // Bind facade
        $this->app->bind('bixo.account', function ($app) {
            return $this->app->make('Bixo\Account\Account');
        });

        // Bind Escrow to repository
        $this->app->bind(
            'Bixo\Account\Interfaces\EscrowRepositoryInterface',
            \Bixo\Account\Repositories\Eloquent\EscrowRepository::class
        );        // Bind EscrowDetails to repository
        $this->app->bind(
            'Bixo\Account\Interfaces\EscrowDetailsRepositoryInterface',
            \Bixo\Account\Repositories\Eloquent\EscrowDetailsRepository::class
        );

        $this->app->register(\Bixo\Account\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Bixo\Account\Providers\RouteServiceProvider::class);
                // $this->app->register(\Bixo\Account\Providers\WorkflowServiceProvider::class);
            }

    /**
     * Merges user's and account's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'bixo.account'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Commands\MakeAccount::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['bixo.account'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('bixo/account.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/account')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/account')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
