<?php

namespace Bixo\Account\Providers;

use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the package.
     *
     * @var array
     */
    protected $policies = [
        // Bind Escrow policy
        'Bixo\Account\Models\Escrow' => \Bixo\Account\Policies\EscrowPolicy::class,// Bind EscrowDetails policy
        'Bixo\Account\Models\EscrowDetails' => \Bixo\Account\Policies\EscrowDetailsPolicy::class,
    ];

    /**
     * Register any package authentication / authorization services.
     *
     * @param \Illuminate\Contracts\Auth\Access\Gate $gate
     *
     * @return void
     */
    public function boot(GateContract $gate)
    {
        parent::registerPolicies($gate);
    }
}
