<?php

namespace Bixo\Account\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class EscrowDetailsTransformer extends TransformerAbstract
{
    public function transform(\Bixo\Account\Models\EscrowDetails $escrow_details)
    {
        return [
            'id'                => $escrow_details->getRouteKey(),
            'key'               => [
                'public'    => $escrow_details->getPublicKey(),
                'route'     => $escrow_details->getRouteKey(),
            ], 
            'escrow_id'         => $escrow_details->escrow_id,
            'date'              => $escrow_details->date,
            'description'       => $escrow_details->description,
            'amount'            => $escrow_details->amount,
            'deleted_at'        => $escrow_details->deleted_at,
            'url'               => [
                'public'    => trans_url('account/'.$escrow_details->getPublicKey()),
                'user'      => guard_url('account/escrow_details/'.$escrow_details->getRouteKey()),
            ], 
            'status'            => trans('app.'.$escrow_details->status),
            'created_at'        => format_date($escrow_details->created_at),
            'updated_at'        => format_date($escrow_details->updated_at),
        ];
    }
}