<?php

namespace Bixo\Account\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class EscrowTransformer extends TransformerAbstract
{
    public function transform(\Bixo\Account\Models\Escrow $escrow)
    {
        return [
            'id'                => $escrow->getRouteKey(),
            'key'               => [
                'public'    => $escrow->getPublicKey(),
                'route'     => $escrow->getRouteKey(),
            ], 
            'agent'             => $escrow->agent,
            'location_id'       => $escrow->location_id,
            'sublocation_id'    => $escrow->sublocation_id,
            'building_id'       => $escrow->building_id,
            'documents'         => $escrow->documents,
            'notes'             => $escrow->notes,
            'deleted_at'        => $escrow->deleted_at,
            'url'               => [
                'public'    => trans_url('account/'.$escrow->getPublicKey()),
                'user'      => guard_url('account/escrow/'.$escrow->getRouteKey()),
            ], 
            'status'            => trans('app.'.$escrow->status),
            'created_at'        => format_date($escrow->created_at),
            'updated_at'        => format_date($escrow->updated_at),
        ];
    }
}