<?php

namespace Bixo\Account\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Bixo\Account\Models\Escrow;

class EscrowAction
{
    /**
     * Perform the complete action.
     *
     * @param Escrow $escrow
     *
     * @return Escrow
     */
    public function complete(Escrow $escrow)
    {
        try {
            $escrow->status = 'complete';
            return $escrow->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param Escrow $escrow
     *
     * @return Escrow
     */public function verify(Escrow $escrow)
    {
        try {
            $escrow->status = 'verify';
            return $escrow->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param Escrow $escrow
     *
     * @return Escrow
     */public function approve(Escrow $escrow)
    {
        try {
            $escrow->status = 'approve';
            return $escrow->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param Escrow $escrow
     *
     * @return Escrow
     */public function publish(Escrow $escrow)
    {
        try {
            $escrow->status = 'publish';
            return $escrow->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param Escrow $escrow
     *
     * @return Escrow
     */
    public function archive(Escrow $escrow)
    {
        try {
            $escrow->status = 'archive';
            return $escrow->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param Escrow $escrow
     *
     * @return Escrow
     */
    public function unpublish(Escrow $escrow)
    {
        try {
            $escrow->status = 'unpublish';
            return $escrow->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
