<?php

namespace Bixo\Account\Workflow;

use Bixo\Account\Models\Escrow;
use Bixo\Account\Notifications\EscrowWorkflow as EscrowNotifyer;
use Notification;

class EscrowNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param Escrow $escrow
     *
     * @return void
     */
    public function complete(Escrow $escrow)
    {
        return Notification::send($escrow->user, new EscrowNotifyer($escrow, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param Escrow $escrow
     *
     * @return void
     */
    public function verify(Escrow $escrow)
    {
        return Notification::send($escrow->user, new EscrowNotifyer($escrow, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param Escrow $escrow
     *
     * @return void
     */
    public function approve(Escrow $escrow)
    {
        return Notification::send($escrow->user, new EscrowNotifyer($escrow, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param Escrow $escrow
     *
     * @return void
     */
    public function publish(Escrow $escrow)
    {
        return Notification::send($escrow->user, new EscrowNotifyer($escrow, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param Escrow $escrow
     *
     * @return void
     */
    public function archive(Escrow $escrow)
    {
        return Notification::send($escrow->user, new EscrowNotifyer($escrow, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param Escrow $escrow
     *
     * @return void
     */
    public function unpublish(Escrow $escrow)
    {
        return Notification::send($escrow->user, new EscrowNotifyer($escrow, 'unpublish'));;

    }
}
