<?php

namespace Bixo\Account\Workflow;

use Bixo\Account\Models\Escrow;
use Validator;

class EscrowValidator
{

    /**
     * Determine if the given escrow is valid for complete status.
     *
     * @param Escrow $escrow
     *
     * @return bool / Validator
     */
    public function complete(Escrow $escrow)
    {
        return Validator::make($escrow->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given escrow is valid for verify status.
     *
     * @param Escrow $escrow
     *
     * @return bool / Validator
     */
    public function verify(Escrow $escrow)
    {
        return Validator::make($escrow->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given escrow is valid for approve status.
     *
     * @param Escrow $escrow
     *
     * @return bool / Validator
     */
    public function approve(Escrow $escrow)
    {
        return Validator::make($escrow->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given escrow is valid for publish status.
     *
     * @param Escrow $escrow
     *
     * @return bool / Validator
     */
    public function publish(Escrow $escrow)
    {
        return Validator::make($escrow->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given escrow is valid for archive status.
     *
     * @param Escrow $escrow
     *
     * @return bool / Validator
     */
    public function archive(Escrow $escrow)
    {
        return Validator::make($escrow->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given escrow is valid for unpublish status.
     *
     * @param Escrow $escrow
     *
     * @return bool / Validator
     */
    public function unpublish(Escrow $escrow)
    {
        return Validator::make($escrow->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
