<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'payroll',

    /*
     * Package.
     */
    'package'   => 'additional',

    /*
     * Modules.
     */
    'modules'   => ['additional_allowance'],

    'image'    => [

        'sm' => [
            'width'     => '140',
            'height'    => '140',
            'action'    => 'fit',
            'watermark' => 'img/logo/default.png',
        ],

        'md' => [
            'width'     => '370',
            'height'    => '420',
            'action'    => 'fit',
            'watermark' => 'img/logo/default.png',
        ],

        'lg' => [
            'width'     => '780',
            'height'    => '497',
            'action'    => 'fit',
            'watermark' => 'img/logo/default.png',
        ],
        'xl' => [
            'width'     => '800',
            'height'    => '530',
            'action'    => 'fit',
            'watermark' => 'img/logo/default.png',
        ],

    ],

    'additional_allowance'       => [
        'model'             => 'Payroll\Additional\Models\AdditionalAllowance',
        'table'             => 'additional_allowances',
        'presenter'         => \Payroll\Additional\Repositories\Presenter\AdditionalAllowanceItemPresenter::class,
        'hidden'            => [],
        'visible'           => [],
        'guarded'           => ['*'],
        'slugs'             => ['slug' => 'name'],
        'dates'             => ['deleted_at'],
        'appends'           => [],
        'fillable'          => ['user_id', 'id',  'company_id',  'department_id',  'employee_id',  'year',  'month',  'head',  'amount',  'remarks',  'created_at',  'updated_at',  'deleted_at'],
        'translate'         => ['id',  'company_id',  'department_id',  'employee_id',  'year',  'month',  'head',  'amount',  'remarks',  'created_at',  'updated_at',  'deleted_at'],

        'upload_folder'     => 'additional/additional_allowance',
        'uploads'           => [
                                    'single'    => [],
                                    'multiple'  => [],
                               ],
        'casts'             => [
                               ],
        'revision'          => [],
        'perPage'           => '20',
        'search'        => [
            'name'  => 'like',
            'status',
        ],
        /*
        'workflow'      => [
            'points' => [
                'start' => 'draft',
                'end'   => ['delete'],
            ],
            'steps'  => [
                'draft'     => [
                    'label'  => "AdditionalAllowance created",
                    'action' => ['setStatus', 'draft'],
                    'next'   => ['complete'],
                ],
                'complete'  => [
                    'label'  => "AdditionalAllowance completed",
                    'status' => ['setStatus', 'complete'],
                    'next'   => ['verify'],
                ],
                'verify'    => [
                    'label'  => "AdditionalAllowance verified",
                    'action' => ['setStatus', 'verify'],
                    'next'   => ['approve'],
                ],
                'approve'   => [
                    'label'  => "AdditionalAllowance approved",
                    'action' => ['setStatus', 'approve'],
                    'next'   => ['publish'],
                ],
                'publish'   => [
                    'label'  => "AdditionalAllowance published",
                    'action' => ['setStatus', 'publish'],
                    'next'   => ['unpublish', 'delete', 'target', 'archive'],
                ],
                'unpublish' => [
                    'label'  => "AdditionalAllowance unpublished",
                    'action' => ['setStatus', 'unpublish'],
                    'next'   => ['publish', 'target', 'archive', 'delete'],
                ],
                'archive'   => [
                    'label'  => "AdditionalAllowance archived",
                    'action' => ['setStatus', 'archive'],
                    'next'   => ['publish', 'delete'],
                ],
                'delete'    => [
                    'Label'  => "AdditionalAllowance deleted",
                    'status' => ['delete', 'archive'],
                ],
            ],
        ],
        */
    ],
];
