<?php

namespace Payroll\Additional;

use User;

class Additional
{
    /**
     * $additional_allowance object.
     */
    protected $additional_allowance;

    /**
     * Constructor.
     */
    public function __construct(\Payroll\Additional\Interfaces\AdditionalAllowanceRepositoryInterface $additional_allowance)
    {
        $this->additional_allowance = $additional_allowance;
    }

    /**
     * Returns count of additional.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.additional_allowance.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->additional_allowance->pushCriteria(new \Litepie\Payroll\Repositories\Criteria\AdditionalAllowanceUserCriteria());
        }

        $additional_allowance = $this->additional_allowance->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('additional::' . $view, compact('additional_allowance'))->render();
    }
}
