<?php

namespace Payroll\Additional\Http\Controllers;

use App\Http\Controllers\AdminController as BaseController;
use Form;
use Payroll\Additional\Http\Requests\AdditionalAllowanceRequest;
use Payroll\Additional\Interfaces\AdditionalAllowanceRepositoryInterface;
use Payroll\Additional\Models\AdditionalAllowance;

/**
 * Admin web controller class.
 */
class AdditionalAllowanceAdminController extends BaseController
{
    // use AdditionalAllowanceWorkflow;
    /**
     * Initialize additional_allowance controller.
     *
     * @param type AdditionalAllowanceRepositoryInterface $additional_allowance
     *
     * @return type
     */
    public function __construct(AdditionalAllowanceRepositoryInterface $additional_allowance)
    {
        $this->repository = $additional_allowance;
        parent::__construct();
    }

    /**
     * Display a list of additional_allowance.
     *
     * @return Response
     */
    public function index(AdditionalAllowanceRequest $request)
    {
        if ($request->wantsJson()) {
            return $this->getJson($request);
        }
        $this   ->theme->prependTitle(trans('additional::additional_allowance.names').' :: ');
        return $this->theme->of('additional::admin.additional_allowance.index')->render();
    }

    /**
     * Display a list of additional_allowance.
     *
     * @return Response
     */
    public function getJson(AdditionalAllowanceRequest $request)
    {
        $pageLimit = $request->input('pageLimit');

        $additional_allowances  = $this->repository
                ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
                ->setPresenter('\\Payroll\\Additional\\Repositories\\Presenter\\AdditionalAllowanceListPresenter')
                ->scopeQuery(function($query){
                    return $query->orderBy('id','DESC');
                })->paginate($pageLimit);
        $additional_allowances['recordsTotal']    = $additional_allowances['meta']['pagination']['total'];
        $additional_allowances['recordsFiltered'] = $additional_allowances['meta']['pagination']['total'];
        $additional_allowances['request']         = $request->all();
        return response()->json($additional_allowances, 200);

    }

    /**
     * Display additional_allowance.
     *
     * @param Request $request
     * @param Model   $additional_allowance
     *
     * @return Response
     */
    public function show(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {
        if (!$additional_allowance->exists) {
            return response()->view('additional::admin.additional_allowance.new', compact('additional_allowance'));
        }

        Form::populate($additional_allowance);
        return response()->view('additional::admin.additional_allowance.show', compact('additional_allowance'));
    }

    /**
     * Show the form for creating a new additional_allowance.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(AdditionalAllowanceRequest $request)
    {

        $additional_allowance = $this->repository->newInstance([]);

        Form::populate($additional_allowance);

        return response()->view('additional::admin.additional_allowance.create', compact('additional_allowance'));

    }

    /**
     * Create new additional_allowance.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(AdditionalAllowanceRequest $request)
    {
        try {
            $attributes             = $request->all();
            $attributes['user_id']  = user_id('admin.web');
            $additional_allowance          = $this->repository->create($attributes);

            return response()->json([
                'message'  => trans('messages.success.updated', ['Module' => trans('additional::additional_allowance.name')]),
                'code'     => 204,
                'redirect' => trans_url('/admin/additional/additional_allowance/'.$additional_allowance->getRouteKey())
            ], 201);


        } catch (Exception $e) {
            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
            ], 400);
        }
    }

    /**
     * Show additional_allowance for editing.
     *
     * @param Request $request
     * @param Model   $additional_allowance
     *
     * @return Response
     */
    public function edit(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {
        Form::populate($additional_allowance);
        return  response()->view('additional::admin.additional_allowance.edit', compact('additional_allowance'));
    }

    /**
     * Update the additional_allowance.
     *
     * @param Request $request
     * @param Model   $additional_allowance
     *
     * @return Response
     */
    public function update(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {
        try {

            $attributes = $request->all();

            $additional_allowance->update($attributes);

            return response()->json([
                'message'  => trans('messages.success.updated', ['Module' => trans('additional::additional_allowance.name')]),
                'code'     => 204,
                'redirect' => trans_url('/admin/additional/additional_allowance/'.$additional_allowance->getRouteKey())
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/additional/additional_allowance/'.$additional_allowance->getRouteKey()),
            ], 400);

        }
    }

    /**
     * Remove the additional_allowance.
     *
     * @param Model   $additional_allowance
     *
     * @return Response
     */
    public function destroy(AdditionalAllowanceRequest $request, AdditionalAllowance $additional_allowance)
    {

        try {

            $t = $additional_allowance->delete();

            return response()->json([
                'message'  => trans('messages.success.deleted', ['Module' => trans('additional::additional_allowance.name')]),
                'code'     => 202,
                'redirect' => trans_url('/admin/additional/additional_allowance/0'),
            ], 202);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/additional/additional_allowance/'.$additional_allowance->getRouteKey()),
            ], 400);
        }
    }

}
